# -*- coding: utf-8 -*-
"""
Created on Wed Dec 23 12:20:09 2020

@author: reinoutubbink
"""

import numpy as np
import matplotlib.pyplot as plt



mode = 1      #Scan mode [1]cyclic voltammetry [2]current-time
EXP = 0

N = 200  #amount of cells
#%% read C++ output file and analyse
plt.close('all')
if EXP == 1:
    JStore = np.loadtxt('Solrun_Fc.txt',skiprows=1)  
    Vacuum = []
    for i in range(len(JStore[:,0])):
        Vacuum.append(-JStore[i][0]-5+0.319)
else:
    JStore = np.loadtxt('BasicDuck.csv', delimiter='\t')  

fig1 = plt.figure('ncurrent')
ax1 = plt.axes()

if mode == 1:
    plt.plot(JStore[:,0],JStore[:,1]*1e3,'k',linewidth=2) 
    plt.tick_params(length=10,width=3,labelsize='30')
    fig = plt.gcf()
    fig.set_size_inches(11, 9, forward=True)
    if EXP:
        ax2 = ax1.twiny()
        ax2.plot(Vacuum,JStore[:,1]*1e3,'k',linewidth=2)
        ax2.set_xlim([-ax1.get_xlim()[0]-5+0.319,-ax1.get_xlim()[1]-5+0.319])
        ax2.tick_params(length=10,width=3,labelsize='30')
        new_tick_locations = np.array([-4.4,-4.6,-4.8,-5.0,-5.2,-5.4,-5.6])
        ax2.set_xticks(new_tick_locations)
if mode == 2: 
    N = 120
    NI = 30
    L = 1e3
    Fth = 700
    res = 0.3                                                                    
    plt.plot(JStore[:,0],JStore[:,1]*1e6)
    plt.xlabel('time (s)', size = '15')                              
    plt.ylabel('Current density (microA/cm^2)', size = '15')
    charge = [0]
    cur = JStore[:,1]
    for i in range(len(cur)):
        charge.append(charge[i]+cur[i]*1000)
    plt.plot(JStore[:,0],charge[1:])
    CELL = np.loadtxt('Endfile.csv', delimiter=',')
    space1 = np.linspace(0,Fth-5*res,25)
    space2 = np.linspace(Fth-4*res,Fth + NI*res,NI+5)
    space3 = np.linspace(Fth +(NI+1)*res, L, N-NI-30)
    dis = np.concatenate((space1,space2,space3))
plt.show